ORCA/M Asm65816 2.1.0

0001 8557              ***          Copyright Apple Computer, Inc. 1985-1989,1991  ***
0002 8557              ***          All Rights Reserved                            ***
0003 8557                       TITLE 'Set up generator control block' 
0004 8557                       EJECT 
0005 8557              ********************************************************
0006 8557              *
0007 8557              * Set.gcb: This routine will set up the gcb parameter block for a 
0008 8557              *          generator.
0009 8557              *
0010 8557              *     Import: sp + D = gen #
0011 8557              *             sp + C = mode
0012 8557              *             sp + B = parameter block bank
0013 8557              *             sp + A = parameter block addrh
0014 8557              *             sp + 9 = parameter block addrl
0015 8557              *             sp + 8 = rts address
0016 8557              *             sp + 6 = rtl address
0017 8557              *             sp + 3 = rtl address
0018 8557              *
0019 8557              ********************************************************
0020 8557
0021 8557                       include 'all.macros' 
0022 8557                       include 'Snd.Equ.aii' 
0023 8557
0024 8557                       import next_wave_chunk 
0025 8557                       import sdoc_ctrl 
0026 8557                       import set_pblock 
0027 8557                       import gcb_xlate 
0028 8557                       import osctable 
0029 8557                       export set_gcb 
0030 8557              set_gcb  proc                           ;
0031 8557                       LONGA OFF
0032 8557                       LONGI OFF
0033 8557 E2 30                 sep   #$30                     ; 8 accum / index regs
0034 8559 A3 11                 lda   gen_no_loc+11,s          ; get the generator number
0035 855B 29 0F                 and   #$0F                     ; 16 generators max
0036 855D C9 0F                 cmp   #$000F                   ; gen 15 reserved for system use
0037 855F 90 03                 bcc   gen_ok                   ; generators 0-E only!
0038 8561 82 96 00              brl   gen_err                  ; invalid generator number
0039 8564 AA           gen_ok   tax                            ;
0040 8565 BF FA 85 02           lda   >gcb_xlate,x             ; get the gcb entry address
0041 8569 AA                    tax                            ; index into gcb table
0042 856A AF B6 1D E1           lda   >sram_base+wap_installed ; check for a valid work area
0043 856E D0 03                 bne   label_01                 ; no work area assigned?
0044 8570 82 79 00              brl   wap_install_err          ;
0045 8573 AF B8 1D E1  label_01 lda   >sram_base+wap_addr+1    ; get the work area pointer
0046 8577 48                    pha                            ;
0047 8578 AF B7 1D E1           lda   >sram_base+wap_addr      ;
0048 857C 48                    pha                            ;
0049 857D 2B                    pld                            ; set new direct register
0050 857E B5 00                 lda   gcb_tbl,x                ; get mode byte for generator
0051 8580 29 0F                 and   #$0F                     ; check the synth mode
0052 8582 F0 03                 beq   gen_not_busy             ; generator free
0053 8584 82 6C 00              brl   gen_busy_err             ;
0054 8587 0F B9 1D E1  gen_not_busy ora   >sram_base+mirq_defined ; check for master irq defined
0055 858B D0 03                 bne   label_00                 ; everybody happy
0056 858D 82 78 00              brl   irq_vect_err             ; otherwise interrupt vector error
0057 8590                       LONGA ON
0058 8590 C2 20        label_00 rep   #$20                     ;
0059 8592 A3 0C                 lda   pptr_addl_loc+11,s       ; parameter table address 
0060 8594 85 F3                 sta   tmp_pram_ptr             ;
0061 8596 A3 0D                 lda   pptr_addh_loc+11,s       ;
0062 8598 85 F4                 sta   tmp_pram_ptr+1           ;
0063 859A A0 0C                 ldy   #next_wave_ptr           ; get the parameter block for possible next waveform
0064 859C B7 F3                 lda   [tmp_pram_ptr],y         ;
0065 859E 95 07                 sta   gcbp_ptr,x               ; set new pointer
0066 85A0 C8                    iny                            ;
0067 85A1 B7 F3                 lda   [tmp_pram_ptr],y         ;
0068 85A3 95 08                 sta   gcbp_ptr+1,x             ;
0069 85A5 C8                    iny                            ; point to the volume
0070 85A6 C8                    iny                            ;
0071 85A7 C8                    iny                            ;
0072 85A8 E2 20                 sep   #$20                     ;
0073 85AA B7 F3                 lda   [tmp_pram_ptr],y         ; get the DOC volume setting
0074 85AC 95 0E                 sta   gcb_doc_volume,x         ;
0075 85AE C2 20                 rep   #$20                     ;
0076 85B0              buff_size_ok                            ;
0077 85B0 A3 10                 lda   mode_loc+11,s            ; get the mode byte
0078 85B2 29 FF 00              and   #$00FF                   ; low nibble
0079 85B5 C9 01 00              cmp   #ffsynth_mode            ; is it free form synthesizer?
0080 85B8 D0 47                 bne   mode_err                 ; an error if not
0081 85BA A3 10                 lda   mode_loc+11,s            ; get the mode & gen #
0082 85BC 95 00                 sta   gcb_mode,x               ; save it
0083 85BE A0 00                 ldy   #wave_start              ; point to the beginning of param block
0084 85C0 B7 F3                 lda   [tmp_pram_ptr],y         ;
0085 85C2 95 02                 sta   gcb_wave_pos,x           ;
0086 85C4 C8                    iny                            ; bump to bank
0087 85C5 B7 F3                 lda   [tmp_pram_ptr],y         ;
0088 85C7 95 03                 sta   gcb_wave_pos+1,x         ;
0089 85C9 C8                    iny                            ;
0090 85CA C8                    iny                            ;
0091 85CB C8                    iny                            ;
0092 85CC B7 F3                 lda   [tmp_pram_ptr],y         ; get the byte count
0093 85CE 95 05                 sta   gcb_wave_count,x         ;
0094 85D0 A0 08                 ldy   #doc_buff_start          ; get the start of the DOC buffer
0095 85D2 B7 F3                 lda   [tmp_pram_ptr],y         ;
0096 85D4 95 0A                 sta   gcb_o0_start,x           ; save it
0097 85D6                       LONGA OFF
0098 85D6                       LONGI OFF
0099 85D6 E2 30                 sep   #$30                     ;
0100 85D8 A0 0A                 ldy   #doc_buff_size           ; get the size of the doc buffer
0101 85DA B7 F3                 lda   [tmp_pram_ptr],y         ; get the doc buffer code
0102 85DC                       LONGA ON
0103 85DC                       LONGI ON
0104 85DC C2 30                 rep   #$30
0105 85DE 29 07 00              and   #$07                     ; three bits
0106 85E1 DA                    phx                            ; save gcb.index
0107 85E2 0A                    asl   A                        ; times 2 for table alignment
0108 85E3 AA                    tax                            ; form table index
0109 85E4 BF 0F 89 02           lda   >buff_siz_tbl,x          ;
0110 85E8 FA                    plx                            ; restore gcb.index
0111 85E9 95 0C                 sta   gcb_doc_count,x          ; save the DOC buffer size
0112 85EB 60                    rts                            ; >>>--- exit set.gcb --->>>
0113 85EC              ;
0114 85EC              ;
0115 85EC                       LONGA ON
0116 85EC                       LONGI ON                       ; changed index registers to long for errors - Braz 8-24-90
0117 85EC
0118 85EC              wap_install_err                         ; wap not installed error
0119 85EC C2 30                 rep   #$30
0120 85EE A9 12 08              lda   #wap_error               ; mark wap not installed error
0121 85F1 38                    sec                            ; mark an error
0122 85F2 60                    rts                            ;
0123 85F3              ;
0124 85F3              ;
0125 85F3              gen_busy_err                            ;
0126 85F3 C2 30                 rep   #$30                     ;
0127 85F5 A9 15 08              lda   #gen_busy_error          ; generator already busy error
0128 85F8 38                    sec                            ; mark an error
0129 85F9 60                    rts                            ;
0130 85FA              ;
0131 85FA              ;
0132 85FA              gen_err                                 ;
0133 85FA C2 30                 rep   #$30                     ;
0134 85FC A9 13 08              lda   #badgen                  ; invalid gen number
0135 85FF 38                    sec                            ; mark an error
0136 8600 60                    rts                            ;
0137 8601              ;
0138 8601              ;
0139 8601              mode_err                                ;
0140 8601 C2 30                 rep   #$30                     ;
0141 8603 A9 14 08              lda   #illmode                 ; generator mode error
0142 8606 38                    sec                            ; mark an error
0143 8607 60                    rts                            ;
0144 8608              ;
0145 8608              ;
0146 8608              irq_vect_err                            ;
0147 8608 C2 30                 rep   #$30                     ;
0148 860A A9 17 08              lda   #mirq_error              ; master irq vector not assigned
0149 860D 38                    sec                            ; mark an error
0150 860E 60                    rts                            ;
0151 860F              ;
0152 860F              ;
0153 860F              buff_siz_tbl                            ;
0154 860F 00 01                 DC W:$0100                     ; 256 bytes for $0
0155 8611 00 02                 DC W:$0200                     ; 512 bytes for $1
0156 8613 00 04                 DC W:$0400                     ; 1024 bytes for $2
0157 8615 00 08                 DC W:$0800                     ; 2048 bytes for $3
0158 8617 00 10                 DC W:$1000                     ; 4096 bytes for $4
0159 8619 00 20                 DC W:$2000                     ; 8192 bytes for $5
0160 861B 00 40                 DC W:$4000                     ; 16384 bytes for $6
0161 861D 00 80                 DC W:$8000                     ; 32768 bytes for $7
0162 861F              ;
0163 861F              ;
0164 861F                       TITLE 'Fill Doc ram buffers' 
0165 861F                       EJECT 
0166 861F              ********************************************************
0167 861F              *
0168 861F              * Setup.doc.ram: This routine will fill the DOC ram buffers for OSC N &
0169 861F              *                osc. N+1.
0170 861F              *
0171 861F              *     Import: e=0, m=0, x=0
0172 861F              *             (gcb.gen) = generator number
0173 861F              *             (gcb.wave.pos) = System ram wave position
0174 861F              *             (gcb.wave.count) = number of waveform byte in sys ram
0175 861F              *             (gcb.o0.start) = start of DOC buffer for osc. N
0176 861F              *             (gcb.doc.count) = number of bytes in DOC buffer
0177 861F              *
0178 861F              ********************************************************
0179 861F              ;
0180 861F              ;
0181 861F                       LONGA ON                       ;
0182 861F                       LONGI ON                       ;
0183 861F                       export setup_doc_ram 
0184 861F              setup_doc_ram                           ;
0185 861F C2 30                 rep   #$30                     ;
0186 8621 A0 00 00              ldy   #$0000                   ; clear index register
0187 8624 98                    tya                            ; clear registers
0188 8625                       LONGA OFF                      ;
0189 8625 E2 20                 sep   #$20                     ;
0190 8627 DA                    phx                            ; save the gcb.index
0191 8628 B5 01                 lda   gcb_gen,x                ; get the generator number
0192 862A 29 0F                 and   #$0F                     ; remove channel info
0193 862C AA                    tax                            ;
0194 862D BF CA 85 02           lda   >osctable,x              ; get the oscillator number
0195 8631 FA                    plx                            ; restore gcb index
0196 8632 48                    pha                            ;
0197 8633 85 F6                 sta   osc_num_temp             ; save oscillator number
0198 8635 A9 03                 lda   #$03                     ; mark a new wave, both oscs.
0199 8637 95 0F                 sta   gcb_new_wave,x           ;
0200 8639 20 89 87              jsr   next_wave_chunk          ; move data for osc N
0201 863C E2 20                 sep   #$20                     ;
0202 863E 68                    pla                            ; get oscillator back
0203 863F 1A                    inc   A                        ; next oscillator
0204 8640 85 F6                 sta   osc_num_temp             ;
0205 8642 B5 00                 lda   gcb_mode,x               ; look for wave ended
0206 8644 10 35                 bpl   @1                       ;
0207 8646 C2 20                 rep   #$20                     ; 16 bits
0208 8648 B5 07                 lda   gcbp_ptr,x               ; next wave parameter pointer
0209 864A 15 08                 ora   gcbp_ptr+1,x             ;
0210 864C D0 10                 bne   @2                       ;
0211 864E C6 F6                 dec   osc_num_temp             ; go back to the even oscillator
0212 8650 20 8A 89              jsr   set_doc_regs             ; init the registers
0213 8653                       LONGA On
0214 8653 A5 FA                 lda   SndFlags                 ; mark only one osc.
0215 8655 09 00 80              ora   #OneOscFlg               ; 
0216 8658 85 FA                 sta   SndFlags                 ;
0217 865A                       LONGA OFF                      ;
0218 865A E2 20                 sep   #$20                     ;
0219 865C 80 2B                 bra   @3                       ; go away
0220 865E 20 4E 87     @2       jsr   set_pblock               ; more waves to follow
0221 8661 E2 20                 sep   #$20                     ;
0222 8663 34 00                 bit   gcb_mode,x               ; has wave ended
0223 8665 10 12                 bpl   @4                       ;
0224 8667 20 8A 89              jsr   set_doc_regs             ; initialize the DOC
0225 866A C2 20                 rep   #$20                     ;
0226 866C B5 07                 lda   gcbp_ptr,x               ; more waves after this?
0227 866E 15 08                 ora   gcbp_ptr+1,x             ;
0228 8670 D0 07                 bne   @4                       ;
0229 8672 E2 20                 sep   #$20                     ;
0230 8674 A9 03                 lda   #$03                     ; no more waves after this
0231 8676 20 31 88              jsr   sdoc_ctrl                ; make it quit
0232 8679              @4                                      ;
0233 8679 80 0E                 bra   @3                       ; go away
0234 867B              @1                                      ;
0235 867B 20 89 87              jsr   next_wave_chunk          ; move data for osc N
0236 867E                       LONGA On
0237 867E C2 20                 rep   #$20                     ; 16 bits
0238 8680 A5 FA                 lda   SndFlags                 ; clear one oscillator marker
0239 8682 29 FF 7F              and   #clrOneOscFlg            ; 
0240 8685 85 FA                 sta   SndFlags                 ;
0241 8687                       LONGA OFF                      ;
0242 8687 E2 20                 sep   #$20                     ; 8 bits
0243 8689
0244 8689 60           @3       rts                            ; >>>--- exit setup.ram --->>>
0245 868A              ;
0246 868A              ;
0247 868A                       TITLE 'Setup DOC registers routine' 
0248 868A                       EJECT 
0249 868A              ********************************************************
0250 868A              *
0251 868A              * Set.DOC.regs: This routine will set up the DOC to run as a FF synth.
0252 868A              *               it sets up the frequency, control registers table size
0253 868A              *               & resolution bits in the DOC.
0254 868A              *
0255 868A              *     Import: A = oscillator number
0256 868A              *             (gcb.doc.siz)  number of pages code ($00-$07)
0257 868A              *             (gcb.o0.start) oscillator N start address
0258 868A              *             (gcb.wave.freq) frequency for oscillator N & osc N+1
0259 868A              *
0260 868A              ********************************************************
0261 868A              ;
0262 868A              ;
0263 868A                       LONGA OFF                      ;
0264 868A                       LONGI OFF                      ;
0265 868A                       export Set_doc_regs 
0266 868A              Set_doc_regs                            ;
0267 868A 08                    php                            ;
0268 868B 8B                    phb                            ; save data bank register
0269 868C 86 F7                 stx   gcb_index_temp           ; save gcb index
0270 868E                       LONGA OFF                      ;
0271 868E                       LONGI OFF                      ;
0272 868E E2 30                 sep   #$30
0273 8690 A9 E1                 lda   #sram_bank               ; set data bank register
0274 8692 48                    pha                            ;
0275 8693 AB                    plb                            ;
0276 8694 A9 00                 lda   #$00                     ; select DOC, no auto incr
0277 8696 0F CA 00 E1           ora   >irq_volume              ; include system volume
0278 869A 8D 3C C0              sta   sgctrl                   ; write to sound glu control
0279 869D A0 0A                 ldy   #doc_buff_size           ; get size of DOC buffer
0280 869F B7 F3                 lda   [tmp_pram_ptr],y         ;
0281 86A1 29 07                 and   #$07                     ; lower three bits
0282 86A3 0A                    asl   A                        ;
0283 86A4 0A                    asl   A                        ;
0284 86A5 0A                    asl   A                        ;
0285 86A6 17 F3                 ora   [tmp_pram_ptr],y         ; form the size and resolution
0286 86A8 EB                    xba                            ; save the data to write
0287 86A9 A5 F6                 lda   osc_num_temp             ; get oscillator number
0288 86AB 18                    clc                            ;
0289 86AC 69 C0                 adc   #ebtr                    ; point to size resolution
0290 86AE AA                    tax                            ;
0291 86AF EB                    xba                            ; get value to write
0292 86B0 8E 3E C0              stx   sgadrl                   ; set register pointer
0293 86B3 8D 3D C0              sta   sgdata                   ; write the byte
0294 86B6 A9 00                 lda   #Efreqlo                 ; point to frequency reg
0295 86B8 18                    clc                            ;
0296 86B9 65 F6                 adc   osc_num_temp             ; point to low freq in oscillator N
0297 86BB AA                    tax                            ; save reg
0298 86BC A0 06                 ldy   #wave_freq               ; get low byte of frequency
0299 86BE B7 F3                 lda   [tmp_pram_ptr],y         ; get the low byte of the freq.
0300 86C0 8E 3E C0              stx   sgadrl                   ; set register pointer
0301 86C3 8D 3D C0              sta   sgdata                   ; write the byte
0302 86C6 A9 20                 lda   #Efreqhi                 ; point to high freq reg
0303 86C8 18                    clc                            ;
0304 86C9 65 F6                 adc   osc_num_temp             ;
0305 86CB AA                    tax                            ;
0306 86CC A0 07                 ldy   #wave_freq+1             ; high byte of frequency
0307 86CE B7 F3                 lda   [tmp_pram_ptr],y         ;
0308 86D0 8E 3E C0              stx   sgadrl                   ; set register pointer
0309 86D3 8D 3D C0              sta   sgdata                   ; write the byte
0310 86D6 A9 40                 lda   #Evol                    ; point DOC volume register
0311 86D8 18                    clc                            ;
0312 86D9 65 F6                 adc   osc_num_temp             ;
0313 86DB AA                    tax                            ;
0314 86DC A0 10                 ldy   #doc_volume              ; get the volume setting
0315 86DE B7 F3                 lda   [tmp_pram_ptr],y         ;
0316 86E0 F0 06                 beq   no_vol_change            ;
0317 86E2 8E 3E C0              stx   sgadrl                   ; set register pointer
0318 86E5 8D 3D C0              sta   sgdata                   ; write the byte
0319 86E8 A9 80        no_vol_change lda   #Ewavpage           ; point to addr pointer
0320 86EA 18                    clc                            ;
0321 86EB 65 F6                 adc   osc_num_temp             ;
0322 86ED A8                    tay                            ; save reg number
0323 86EE A6 F7                 ldx   gcb_index_temp           ; get the gcb index back
0324 86F0 B5 0B                 lda   gcb_o0_start+1,x         ; get high byte of address
0325 86F2 48                    pha                            ; save page
0326 86F3 98                    tya                            ; get the oscillator number
0327 86F4 6A                    ror   A                        ;
0328 86F5 68                    pla                            ; get page number back
0329 86F6 90 03                 bcc   even_osc                 ; if odd must bump start address
0330 86F8 18                    clc                            ;
0331 86F9 75 0D                 adc   gcb_doc_count+1,x        ; calc new page number
0332 86FB              even_osc                                ;
0333 86FB BB                    tyx                            ; get oscillator number back
0334 86FC 8E 3E C0              stx   sgadrl                   ; set register pointer
0335 86FF 8D 3D C0              sta   sgdata                   ; write the byte
0336 8702 A9 A0                 lda   #eocr                    ; point to the control register
0337 8704 18                    clc                            ;
0338 8705 65 F6                 adc   osc_num_temp             ;
0339 8707 48                    pha                            ; save data to write
0340 8708 A6 F7                 ldx   gcb_index_temp           ; get the gcb index
0341 870A B5 01                 lda   gcb_gen,x                ; get the channel info
0342 870C 29 F0                 and   #$F0                     ;
0343 870E 09 0F                 ora   #$0F                     ; remove halt mode 4 (11)
0344 8710 FA                    plx                            ; get new reg  number back
0345 8711 8E 3E C0              stx   sgadrl                   ; set register pointer
0346 8714 8D 3D C0              sta   sgdata                   ; write the byte
0347 8717 A6 F7                 ldx   gcb_index_temp           ; get gcb index back
0348 8719 AB                    plb                            ; restore data bank register
0349 871A 28                    plp                            ; restore status register
0350 871B 60                    rts                            ; >>>--- exit set.doc.regs --->>>
0351 871C
0352 871C                       endp 
0353 871C                       end   
